<?php

require_once 'process.php';
require_once 'database.php';

function send_email($data) {
	$to = $data['to'];
	$sub = $data['sub'];
	$msg = $data['msg'];
	$message = get_email_msg($data);
	$header = "From: info@valley-express.com \r\n";
	$header .= "MIME-Version: 1.0\r\n";
	$header .= "Content-type: text/html\r\n";
	$retval = mail ($to,$sub,$message,$header);
}

function get_email_msg($data) {
	$msg_text = "";
	
	switch($data['msg']) {
		
		case 'acc_open':
			$msg_text = '';
		break;
		
		case 'otp':
			$msg_text = sprintf("You have initiated a funds transfer from your online banking user account, below is your Premire Financial Bank One Time Transaction (OTP) Authorization Code : %u", $data['token']);
		break;
		
		
		case 'change_pwd':
			$msg_text = sprintf("Your password was successfully changed. New Password is : %s", $data['pwd']);
		break;
		
		case 'change_pin':
			$msg_text = sprintf("Your PIN was successfully changed. New PIN is : %u", $data['pin']);
		break;		
		
		case 'transfer':
			$msg_text = $data['body'];
		break;
		
		case 'register':
			$msg_text = $data['body'];
		break;
		
		case 'transaction':
			$msg_text = $data['body'];
		break;
		
		case 'funds_transfer_mail':
			$msg_text = $data['body'];
		break;
		
	}//switch
	return $msg_text;
}

?>